var map = {
    "id": "id",
    "name": "title",
    "file_url": "file.path",
    "created_at": "created_at",
    "tags": "tags",
    // "page_url": "url",
};
var mediaMap = {
    "url": "url",
    "file_size": "filesize",
    "width": "width",
    "height": "height",
};
var ratingMap = {
    e: "general",
    t: "safe",
    m: "questionable",
    a: "explicit",
};
function parseJsonImage(data) {
    var img = Grabber.mapFields(data, map);
    img.rating = ratingMap[data["suitability"]];
    var user = data["users"].filter(function (u) { return u["primary"]; });
    img.author = user["user_name"];
    img.author_id = user["id"];
    img.medias = data["icons"]
        .concat(data["files"])
        .map(function (media) { return Grabber.mapFields(media, mediaMap); });
    console.log("img.medias", img.medias);
    return img;
}
var meta = {
    order: {
        type: "options",
        options: ["date", "score", "views"],
        default: "date",
    },
    approved: {
        type: "bool",
    },
};
export var source = {
    name: "Newgrounds Art",
    meta: meta,
    apis: {
        json: {
            name: "JSON",
            auth: [],
            forcedLimit: 28,
            search: {
                url: function (query, opts) {
                    var parsed = Grabber.parseSearchQuery(query.search, meta);
                    if (parsed.query) {
                        return { error: "Cannot search in JSON mode." };
                    }
                    var offset = (query.page - 1) * opts.limit;
                    var artistType = parsed.approved === true ? "approved" : (parsed.approved === false ? "undiscovered" : "all");
                    return {
                        url: "/browse?interval=all&sort=" + parsed.order + "&genre=0&artist-type=" + artistType + "&offset=" + offset,
                        headers: {
                            "X-Requested-With": "XMLHttpRequest",
                        },
                    };
                },
                parse: function (src) {
                    console.log(src, "src");
                    var data = JSON.parse(src);
                    return {
                        images: data["total"]["hits"].map(function (img) { return parseJsonImage(img["_source"]); }),
                        imageCount: data["total"]["total"]["relation"] === "eq" ? data["total"]["total"]["value"] : undefined,
                    };
                },
            },
            check: {
                url: function () {
                    return "/";
                },
                parse: function (src) {
                    return src.indexOf("www.newgrounds.com") !== -1;
                },
            },
        },
    },
};
